#!/bin/bash

# Directorio donde se encuentran los .log
DIR="."

# IP y puerto destino
TARGET_IP="158.23.56.102"
TARGET_PORT="9100"

echo "==========================================="
echo "   Enviando archivos .log (últimos 3 días)"
echo "   Destino: $TARGET_IP:$TARGET_PORT"
echo "==========================================="

find "$DIR" -maxdepth 1 -type f -name '*.log' -mtime -3 -printf '%T@ %p\0' \
| sort -rz -n -r \
| while IFS= read -r -d $'\0' e; do

    f="${e#* }"
    f="${f#./}"

    echo ""
    echo "-------------------------------------------"
    echo "Enviando archivo: $f"
    echo "-------------------------------------------"

    nc -N "$TARGET_IP" "$TARGET_PORT" < "$f" 2>/dev/null \
        || nc -q 0 "$TARGET_IP" "$TARGET_PORT" < "$f"

    echo "✔ Enviado. Esperando 7 segundos..."
    sleep 3
done

echo ""
echo "==========================================="
echo "   Proceso terminado."
echo "==========================================="
